# Algorithme du calcul de la moyenne

## Spécification du problème

L'algorithme doit calculer la moyenne des valeurs du tableau. Il pourrait s'agir 
de notes, de températures, .... Si le tableau est vide, la moyenne ne peut 
être calculée (cf division par 0) et la fonction ne doit rien renvoyer.

## Implémentation en Python

```python
from typing import List
def moyenne(valeurs : List[float]) -> float:
	""" calcule la moyenne
	@param valeurs les valeurs dont il faut calculer la moyenne
	@return la moyenne des valeurs : somme(valeurs) / nombre(valeurs), ou None en l'absence de valeurs
	>>> moyenne([])
	None
	>>> moyenne([15, 18, 12])
	15.0
	"""
		if len(valeurs) == 0:
			moyenne = None
		else:
			total = 0
			for i in range(len(valeurs)):
				total = total + valeurs[i]
			moyenne = total / len(valeurs)
		return moyenne

if __name__ == "__main__":
	import doctest; doctest.testmod()
	print(moyenne([15, 18, 12]))
```

## Qualité

### Preuve de correction partielle

Invariant : à chaque itérative, "total" contient la somme des valeurs du tableau entre les entre les indices 0 et i.


### Preuve de terminaison

Une itérative pour se termine par définition.


### Complexité

Soit "n"le nombre de valeurs. Chaque valeur est cumulée. Si on dénombre le nombre 
d'additions, il y en a "n". la complexité est donc en "O(n)".
